﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO.Ports;
using System.Threading;

namespace ITA_580
{
    public partial class Form1 : Form
    {
        public static IntPtr gPtrAEC;
        public static IntPtr gPtrAecInit;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            byte sts = 255;
            byte res;
            string str;
            byte[] name = new byte[17];

            gPtrAEC = LoadLibrary(@"AEC64.dll");

            gPtrAecInit = AecInitialize(ref sts);

            if (sts != 0)
            {
                MessageBox.Show("AecInit Error " + sts.ToString(), "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Application.Exit();
            }
            else
            {
                //check project is ITA-5 serial
                res = AecInfoGetBoardName(gPtrAecInit, name);
                if (res != 0)
                {
                    MessageBox.Show("Get Board Name Error ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    Application.Exit();
                }
                else
                {
                    name[16] = 0;
                    str = Encoding.Default.GetString(name);
                    if (str.StartsWith("ITA-5") == false)
                    {
                        MessageBox.Show("Only for ITA-5 serial ", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                        Application.Exit();
                    }
                }

                //check SMBus
                CheckSmbusPeripheral();

                //Ignition
                CheckIgnitionControl();
                ShowIgnition();

                //DC in status
                ShowDcInStatus();
                ShowDcInVoltage();

                //Super-Cap
                ConfigSuperCap();
                ShowSuperCap();

                //MXM
                CheckMxmFan();
                ShowMxmInformation();

                //DIO
                //ConfigDio();
                ShowDioInputStatus();
                ShowDioOutputStatus();

                //WatchDog Timer
                //ShowWatchDogTime();

                //enable refresh timer
                timer1.Enabled = true;
            }
        }

        private void Form1_Refresh(object sender, EventArgs e)
        {
            //disable refresh timer
            timer1.Enabled = false;

            //Ignition
            ShowIgnitionStatus();

            //DC in status
            ShowDcInStatus();
            ShowDcInVoltage();

            //Super-Cap
            ShowSuperCap();

            //MXM
            ShowMxmInformation();

            //DIO
            ShowDioInputStatus();

            //enable refresh timer
            timer1.Enabled = true;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            AecUninitialize(gPtrAecInit);
            FreeLibrary(gPtrAEC);
        }

        //Ignition
        private void CtlByBIOS_CheckedChanged(object sender, EventArgs e)
        {
            SetIgnitionControl();
            ShowIgnition();
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            comboBox1.Enabled = false;
            comboBox2.Enabled = false;
            comboBox3.Enabled = false;
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            comboBox1.Enabled = true;
            comboBox2.Enabled = true;
            comboBox3.Enabled = true;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (radioButton1.Checked == true)   //disable
            {
                SetIgnitionControlMode(0);
            }
            else if (radioButton2.Checked == true)  //enable
            {
                SetIgnitionControlMode(1);
            }
        }

        //WatchDog Timer
        private void button1_Click(object sender, EventArgs e)
        {
            SetWatchDogStart();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            SetWatchDogStop();
        }

        //DIO
        private void radioButton13_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton13.Checked == true)
            {
                SetDioOutput(0, 1);
            }
        }

        private void radioButton12_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton12.Checked == true)
            {
                SetDioOutput(0, 0);
            }
        }

        private void radioButton16_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton16.Checked == true)
            {
                SetDioOutput(1, 1);
            }
        }

        private void radioButton15_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton15.Checked == true)
            {
                SetDioOutput(1, 0);
            }
        }

        private void radioButton19_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton19.Checked == true)
            {
                SetDioOutput(2, 1);
            }
        }

        private void radioButton18_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton18.Checked == true)
            {
                SetDioOutput(2, 0);
            }
        }

        private void radioButton22_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton22.Checked == true)
            {
                SetDioOutput(3, 1);
            }
        }

        private void radioButton21_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton21.Checked == true)
            {
                SetDioOutput(3, 0);
            }
        }

        //Super-Cap
        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked == true)
            {
                groupBox1.Width = 435;
                this.Width = 1265;
            }
            else if (checkBox1.Checked == false)
            {
                groupBox1.Width = 271;
                this.Width = 1102;
            }
        }
    }
}
